/*******************************************************
Filename		:  FA_HABITAT_RESULT_const.sql
Release 		:  c2.0
SIR			:  1496
Description		:  create fk constraints for FA_HABITAT_RESULT fact table.
Author			:  Bill Nash
Date			:  07/08/2003
Comments		:  Created program based on Regular Results
			:  09/02/2003 removed constraints for fk_mad_hmethod and fk_mad_hdatum.  WN 
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
			   01/26/04 - SIR 1571 Create constraint on FK_STN_ACT_PT -JW
			   06/09/04 - created constraint on FK_STD_HDATUM - GT    
**********************************************************/
spool FA_HABITAT_RESULT_const.log
set echo on

alter table FA_HABITAT_RESULT
add constraint hb_fk_sd_org foreign key (fk_org) references di_org(pk_isn);

--alter table FA_HABITAT_RESULT
--add constraint hb_fk_mad_hmethod foreign key (fk_mad_hmethod ) references lu_mad_hmethod(pk_isn);

--alter table FA_HABITAT_RESULT
--add constraint hb_fk_mad_hdatum foreign key (fk_mad_hdatum ) references lu_mad_hdatum(pk_isn);

alter table FA_HABITAT_RESULT 
add constraint hb_fk_sd_geo_state foreign key (fk_geo_state) references di_geo_state(pk_isn);

alter table FA_HABITAT_RESULT 
add constraint hb_fk_sd_geo_county foreign key (fk_geo_county) references di_geo_county(pk_isn);

alter table FA_HABITAT_RESULT 
add constraint hb_fk_sd_db_cat foreign key (fk_db_cat) references di_db_cat(pk_isn);

alter table FA_HABITAT_RESULT 
add constraint hb_fk_station foreign key (fk_station) references fa_station(pk_isn);

alter table FA_HABITAT_RESULT 
add constraint hb_fk_char foreign key (fk_char) references di_characteristic(pk_isn);

--may need additional constraints

alter table FA_HABITAT_RESULT 
add constraint hb_fk_act_mad_hdatum foreign key (fk_act_mad_hdatum) references lu_mad_hdatum(pk_isn);

alter table FA_HABITAT_RESULT 
add constraint hb_fk_act_mad_hmethod foreign key (fk_act_mad_hmethod) references lu_mad_hmethod(pk_isn);

alter table FA_HABITAT_RESULT 
add constraint hb_fk_date_act_start foreign key (fk_date_act_start) references di_date(pk_isn);

--alter table FA_HABITAT_RESULT 
--add constraint hb_fk_act_medium foreign key (fk_act_medium) references di_activity_medium(pk_isn);

-- For version 2.0
--alter table FA_HABITAT_RESULT 
--add constraint hb_fk_act_matrix foreign key (fk_act_matrix) references di_activity_matrix(pk_isn);

--Added 1-26 for SIR 1571
alter table FA_HABITAT_RESULT 
add constraint hb_fk_stn_act_pt foreign key (fk_stn_act_pt) references fa_station(pk_isn);
/*
--added 06/9/2004
alter table FA_HABITAT_RESULT 
add constraint hb_FK_STD_HDATUM foreign key (FK_STD_HDATUM) references lu_mad_hdatum(pk_isn);
*/
commit;
spool off;